<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProcessStep extends Model 
{

    protected $table = 'process_steps';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id', 'process_id', 'process_version', 'name_ar', 'name_en', 'order', 'target');

    public function duration()
    {
        return $this->morphOne('App\Models\User', 'related');
    }

    public function target()
    {
        return $this->morphTo();
    }

}